package com.ensoft.ace.infrastructure.service;

import android.content.Context;
import android.graphics.Color;

import com.ensoft.ace.domain.model.Flowmetry;
import com.jjoe64.graphview.series.DataPoint;
import com.jjoe64.graphview.series.LineGraphSeries;
import com.jjoe64.graphview.series.PointsGraphSeries;
import com.jjoe64.graphview.series.Series;

import java.util.ArrayList;
import java.util.List;

public class LiverpoolNomogramMalesService extends LiverpoolNomogramService
{
	public LiverpoolNomogramMalesService( Context context, Flowmetry flowmetry, boolean fromEscPos )
	{
		super( context, flowmetry, fromEscPos );
	}
	
	@Override
	protected List<Series<DataPoint>> getSeriesGraphLeft()
	{
		List<Series<DataPoint>> series = new ArrayList<>();
		
		//QMax 50th
		LineGraphSeries<DataPoint> eje1 = new LineGraphSeries<>();
		eje1.setTitle( "50th" );
		eje1.setColor( Color.BLUE );
		int step = 10;
		for ( int i = 0; i <= 600; i += step )
		{
			eje1.appendData( new DataPoint( i, getQMax50Th( i ) ), true, 100 );
		}
		
		//QMax 95th
		LineGraphSeries<DataPoint> eje2 = new LineGraphSeries<>();
		eje2.setTitle( "95th" );
		eje2.setColor( Color.RED );
		for ( int i = 0; i <= 600; i += step )
		{
			eje2.appendData( new DataPoint( i, getQMax95Th( i ) ), true, 100 );
		}
		
		//QMax 5th
		LineGraphSeries<DataPoint> eje3 = new LineGraphSeries<>();
		eje3.setTitle( "5th" );
		eje3.setColor( Color.GREEN );
		for ( int i = 0; i <= 600; i += step )
		{
			eje3.appendData( new DataPoint( i, getQMax5Th( i ) ), true, 100 );
		}
		
		series.add( eje2 );
		series.add( eje1 );
		series.add( eje3 );
		
		PointsGraphSeries<DataPoint> ejeRes = new PointsGraphSeries<>();
		ejeRes.setTitle( "Res." );
		ejeRes.setColor( Color.MAGENTA );
		ejeRes.appendData( new DataPoint( Math.min( 600, (int)flowmetry.getTotalVol() ), (int)flowmetry.getQMax() ), true, 100 );
		series.add( ejeRes );
		
		return series;
	}
	
	@Override
	protected List<Series<DataPoint>> getSeriesGraphRight()
	{
		List<Series<DataPoint>> series = new ArrayList<>();
		
		//QMax 50th
		LineGraphSeries<DataPoint> eje1 = new LineGraphSeries<>();
		eje1.setTitle( "50th" );
		eje1.setColor( Color.BLUE );
		int step = 10;
		for ( int i = 0; i <= 600; i += step )
		{
			eje1.appendData( new DataPoint( i, getQAve50Th( i ) ), true, 100 );
		}
		
		//QMax 95th
		LineGraphSeries<DataPoint> eje2 = new LineGraphSeries<>();
		eje2.setTitle( "95th" );
		eje2.setColor( Color.RED );
		for ( int i = 0; i <= 600; i += step )
		{
			eje2.appendData( new DataPoint( i, getQAve95Th( i ) ), true, 100 );
		}
		
		//QMax 5th
		LineGraphSeries<DataPoint> eje3 = new LineGraphSeries<>();
		eje3.setTitle( "5th" );
		eje3.setColor( Color.GREEN );
		for ( int i = 0; i <= 600; i += step )
		{
			eje3.appendData( new DataPoint( i, getQAve25Th( i ) ), true, 100 );
		}
		
		series.add( eje2 );
		series.add( eje1 );
		series.add( eje3 );
		
		PointsGraphSeries<DataPoint> ejeRes = new PointsGraphSeries<>();
		ejeRes.setTitle( "Res." );
		ejeRes.setColor( Color.MAGENTA );
		ejeRes.appendData( new DataPoint( Math.min( 600, (int)flowmetry.getTotalVol() ), (int)flowmetry.getQAverage() ), true, 100 );
		series.add( ejeRes );
		
		return series;
	}
	
	protected double getQMax50Th( int vol )
	{
		return Math.pow( ( 1.58 + 0.18 * Math.sqrt( vol ) ), 2 );
	}
	
	protected double getQMax95Th( int vol )
	{
		return Math.pow( ( 2.8 + 0.18 * Math.sqrt( vol ) ), 2 );
	}
	
	protected double getQMax5Th( int vol )
	{
		return Math.pow( ( 0.431 + 0.18 * Math.sqrt( vol ) ), 2 );
	}
	
	protected double getQAve50Th( int vol )
	{
		return Math.pow( ( 1.14 + 0.14 * Math.sqrt( vol ) ), 2 );
	}
	
	protected double getQAve95Th( int vol )
	{
		return Math.pow( ( 2.035 + 0.14 * Math.sqrt( vol ) ), 2 );
	}
	
	protected double getQAve25Th( int vol )
	{
		return Math.pow( ( 0.215 + 0.14 * Math.sqrt( vol ) ), 2 );
	}
}
