package com.ensoft.ace.infrastructure.service;

import android.content.Context;
import android.graphics.Color;

import com.ensoft.ace.domain.model.Flowmetry;
import com.jjoe64.graphview.series.DataPoint;
import com.jjoe64.graphview.series.LineGraphSeries;
import com.jjoe64.graphview.series.PointsGraphSeries;
import com.jjoe64.graphview.series.Series;

import java.util.ArrayList;
import java.util.List;

public class LiverpoolNomogramFemalesService extends LiverpoolNomogramService
{
	public LiverpoolNomogramFemalesService( Context context, Flowmetry flowmetry, boolean fromEscPos )
	{
		super( context, flowmetry, fromEscPos );
	}
	
	@Override
	protected List<Series<DataPoint>> getSeriesGraphLeft()
	{
		List<Series<DataPoint>> series = new ArrayList<>();
		
		//QMax 50th
		LineGraphSeries<DataPoint> eje1 = new LineGraphSeries<>();
		eje1.setTitle( "50th" );
		eje1.setColor( Color.BLUE );
		int step = 10;
		
		//QMax 95th
		LineGraphSeries<DataPoint> eje2 = new LineGraphSeries<>();
		eje2.setTitle( "95th" );
		eje2.setColor( Color.RED );
		
		//QMax 5th
		LineGraphSeries<DataPoint> eje3 = new LineGraphSeries<>();
		eje3.setTitle( "5th" );
		eje3.setColor( Color.GREEN );
		for ( int i = 0; i <= 600; i += step )
		{
			eje1.appendData( new DataPoint( i, GetQMax50th( i ) ), true, 100 );
			eje2.appendData( new DataPoint( i, GetQMax95th( i ) ), true, 100 );
			eje3.appendData( new DataPoint( i, GetQMax5th( i ) ), true, 100 );
		}
		
		series.add( eje2 );
		series.add( eje1 );
		series.add( eje3 );
		
		PointsGraphSeries<DataPoint> ejeRes = new PointsGraphSeries<>();
		ejeRes.setTitle( "Res." );
		ejeRes.setColor( Color.MAGENTA );
		ejeRes.appendData( new DataPoint( Math.min( 600, (int)flowmetry.getTotalVol() ), (int)flowmetry.getQMax() ), true, 100 );
		series.add( ejeRes );
		
		return series;
	}
	
	@Override
	protected List<Series<DataPoint>> getSeriesGraphRight()
	{
		List<Series<DataPoint>> series = new ArrayList<>();
		int start = 3;
		int step = 10;
		
		//QMax 50th
		LineGraphSeries<DataPoint> eje1 = new LineGraphSeries<>();
		eje1.setTitle( "50th" );
		eje1.setColor( Color.BLUE );
		
		//QMax 95th
		LineGraphSeries<DataPoint> eje2 = new LineGraphSeries<>();
		eje2.setTitle( "95th" );
		eje2.setColor( Color.RED );
		
		//QMax 5th
		LineGraphSeries<DataPoint> eje3 = new LineGraphSeries<>();
		eje3.setTitle( "5th" );
		eje3.setColor( Color.GREEN );
		
		for ( int i = start; i <= 600; i += step )
		{
			eje1.appendData( new DataPoint( i, GetQAve50th( i ) ), true, 100 );
			eje2.appendData( new DataPoint( i, GetQAve95th( i ) ), true, 100 );
			eje3.appendData( new DataPoint( i, GetQAve25th( i ) ), true, 100 );
		}
		
		series.add( eje2 );
		series.add( eje1 );
		series.add( eje3 );
		
		PointsGraphSeries<DataPoint> ejeRes = new PointsGraphSeries<>();
		ejeRes.setTitle( "Res." );
		ejeRes.setColor( Color.MAGENTA );
		ejeRes.appendData( new DataPoint( Math.min( 600, (int)flowmetry.getTotalVol() ), (int)flowmetry.getQAverage() ), true, 100 );
		series.add( ejeRes );
		
		return series;
	}
	
	protected double GetQMax50th( int vol )
	{
		return Math.exp( 0.511 + 0.505 * Math.log( vol ) );
	}
	
	protected double GetQMax95th( int vol )
	{
		return Math.exp( 1.06 + 0.505 * Math.log( vol ) );
	}
	
	protected double GetQMax5th( int vol )
	{
		return Math.exp( -0.05 + 0.505 * Math.log( vol ) );
	}
	
	protected double GetQAve50th( int vol )
	{
		return Math.pow( ( -0.92 + 0.869 * Math.log( vol ) ), 2 );
	}
	
	protected double GetQAve95th( int vol )
	{
		return Math.pow( ( -1.95 + 0.869 * Math.log( vol ) ), 2 );
	}
	
	protected double GetQAve25th( int vol )
	{
		return Math.pow( ( -0.89 + 1.07 * Math.log( vol ) ), 2 );
	}
}
