package com.ensoft.ace.infrastructure.service;

import android.app.Activity;
import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

import com.ensoft.ace.domain.model.Flowmetry;
import com.ensoft.ace.domain.model.PatientCard;
import com.ensoft.ace.domain.service.graphview.DateXAsSecsLabelFormatter;
import com.jjoe64.graphview.DefaultLabelFormatter;
import com.jjoe64.graphview.GraphView;
import com.jjoe64.graphview.LegendRenderer;
import com.jjoe64.graphview.series.DataPoint;
import com.jjoe64.graphview.series.LineGraphSeries;

import java.text.NumberFormat;

public class GraphPrinterService
{
	private static int PIXEL_DENSITY = 2;
	private static int SHEET_WIDTH = 592 * PIXEL_DENSITY;
	private static int SHEET_HEIGHT = 840 * PIXEL_DENSITY;

	public interface GraphReadyListener {
		void onGraphReady( View graphLayout );
	}

	public interface LiverpoolGraphReadyListener {
		void onGraphReady( View graphLayout, LiverpoolNomogramService liverpoolNomogramService );
	}

	public static void drawFlowmetryGraph( Activity activity, Flowmetry flowmetry, GraphReadyListener graphReadyListener )
	{
		// graph
		LineGraphSeries<DataPoint> graphVolume;
		LineGraphSeries<DataPoint> graphFlow;

		graphVolume = new LineGraphSeries<>();
		graphVolume.setTitle( "Volumen ( ml )" );
		graphVolume.setColor( Color.BLUE );
		graphVolume.setThickness( 2 );

		graphFlow = new LineGraphSeries<>();
		graphFlow.setTitle( "Flujo ( ml / s )" );
		graphFlow.setColor( Color.RED );
		graphFlow.setThickness( 2 );

		GraphView graphView = new GraphView( activity );
		graphView.getViewport().setScrollable( true );

		graphView.setBackgroundColor( 0x000000 );
		LegendRenderer lr = graphView.getLegendRenderer();
		lr.setVisible( true );
		lr.setAlign( LegendRenderer.LegendAlign.TOP );
		lr.setTextSize( 12 * PIXEL_DENSITY );
		lr.setBackgroundColor( Color.argb( 100, 100, 100, 100 ) );

		graphView.addSeries( graphFlow ); // data
		graphView.setTitleTextSize( 12 );
		graphView.getViewport().setYAxisBoundsManual( true );
		graphView.getViewport().setMinY( 0 );
		NumberFormat nf = NumberFormat.getInstance();
		nf.setMaximumFractionDigits( 0 );
		nf.setMinimumFractionDigits( 0 );
		graphView.getGridLabelRenderer().setLabelFormatter( new DateXAsSecsLabelFormatter( nf, nf ) );
		graphView.getGridLabelRenderer().setTextSize( 10 * PIXEL_DENSITY );
		graphView.getGridLabelRenderer().setNumVerticalLabels( 6 );
		graphView.getGridLabelRenderer().setNumHorizontalLabels( 6 );

		graphView.getSecondScale().addSeries( graphVolume );
		graphView.getSecondScale().setMinY( 0 );
		graphView.getSecondScale().setMaxY( 1000 );

		RelativeLayout graphLayout = new RelativeLayout( activity );
		int px = SHEET_WIDTH / 2; //(int) TypedValue.applyDimension( TypedValue.COMPLEX_UNIT_MM, 25, activity.getResources().getDisplayMetrics() );
		RelativeLayout.LayoutParams GraphLayoutParams = new RelativeLayout.LayoutParams( px, px );
		graphLayout.setLayoutParams( GraphLayoutParams );
		graphLayout.setVisibility( View.INVISIBLE );
		graphLayout.addView( graphView );
		ViewGroup rootView = activity.getWindow().getDecorView().findViewById( android.R.id.content );
		rootView.addView( graphLayout );

		int dataPos = 0;
		int init = flowmetry.getTimeInit();
		int size = flowmetry.getTimeEnd() - flowmetry.getTimeInit();
		int[] flow = flowmetry.getFlowHist();
		int[] vol = flowmetry.getVolumHist();

		DataPoint[] flowDP = new DataPoint[size];
		DataPoint[] volDP = new DataPoint[size];

		int pos;
		float maxY = 30;
		float flowCur;

		for ( int i = 0; i < size; i++ )
		{
			pos = init + i;
			dataPos += 1d;

			flowCur = flow[pos] / 5.f;

			flowDP[i] = new DataPoint( dataPos, flow[pos] / 5.f );
			volDP[i] = new DataPoint( dataPos, vol[pos] / 4.f );

			if ( flowCur > 50 )
			{
				maxY = flowCur + 5;
			}
			else if ( flowCur > 30 )
			{
				maxY = 50;
			}
		}

		graphVolume.resetData( volDP );
		graphFlow.resetData( flowDP );

		int perMin = ( 1000 / new PreferenceService().getLatency() ) * 60;
		int maxRoundedX = ( (int) Math.floor( size / perMin ) + 1 ) * perMin;

		graphView.getViewport().setXAxisBoundsManual( true );
		graphView.getViewport().setMinX( 0 );
		graphView.getViewport().setMaxX( maxRoundedX );
		graphView.getViewport().setYAxisBoundsManual( true );
		graphView.getViewport().setMaxY( maxY );

		ViewTreeObserver vto = graphLayout.getViewTreeObserver();
		vto.addOnGlobalLayoutListener( new ViewTreeObserver.OnGlobalLayoutListener()
		{
			@Override
			public void onGlobalLayout()
			{
				graphLayout.getViewTreeObserver().removeOnGlobalLayoutListener( this );
				graphReadyListener.onGraphReady( graphLayout );
			}
		} );
	}

	public static void drawLiverpoolGraph( Activity activity, Flowmetry flowmetry, int orientation, PatientCard patientCard, LiverpoolGraphReadyListener graphReadyListener )
	{
		LiverpoolNomogramService liverpoolNomogramService = patientCard.getGender().equals( "Mujer" ) ?
				new LiverpoolNomogramFemalesService( activity, flowmetry, true ) :
				new LiverpoolNomogramMalesService( activity, flowmetry, true );

		ViewGroup rootView = activity.getWindow().getDecorView().findViewById( android.R.id.content );

		LinearLayout graphLayout = new LinearLayout( activity );
		graphLayout.setOrientation( orientation );
		LinearLayout.LayoutParams LLParams = new LinearLayout.LayoutParams(
				orientation == LinearLayout.HORIZONTAL ? SHEET_WIDTH - MetricsService.cmToPs( 2 * PIXEL_DENSITY ) : SHEET_WIDTH / 2 - MetricsService.cmToPs( 1 ),
				orientation == LinearLayout.HORIZONTAL ? SHEET_WIDTH / 2 : SHEET_HEIGHT / 2 );
		graphLayout.setWeightSum( 1f );
		graphLayout.setLayoutParams( LLParams );

		GraphView maxGraph = liverpoolNomogramService.getVolMaxGraph();
		GraphView avgGraph = liverpoolNomogramService.getAverageGraph();

		FrameLayout ladderFL = new FrameLayout( activity );
		LinearLayout.LayoutParams ladderFLParams = new LinearLayout.LayoutParams(
				orientation == LinearLayout.HORIZONTAL ? 0 : LinearLayout.LayoutParams.MATCH_PARENT,
				orientation == LinearLayout.HORIZONTAL ? LinearLayout.LayoutParams.MATCH_PARENT : 0 );
		ladderFLParams.weight = 0.5f;
		ladderFL.setLayoutParams( ladderFLParams );
		ladderFL.addView( maxGraph );

		LegendRenderer lr = maxGraph.getLegendRenderer();
		lr.setVisible( true );
		lr.setAlign( LegendRenderer.LegendAlign.TOP );
		lr.setTextSize( 12 * PIXEL_DENSITY );
		lr.setBackgroundColor( Color.argb( 100, 100, 100, 100 ) );

		lr = avgGraph.getLegendRenderer();
		lr.setVisible( true );
		lr.setAlign( LegendRenderer.LegendAlign.TOP );
		lr.setTextSize( 12 * PIXEL_DENSITY );
		lr.setBackgroundColor( Color.argb( 100, 100, 100, 100 ) );

		NumberFormat nf = NumberFormat.getInstance();
		nf.setMaximumFractionDigits( 0 );
		nf.setMinimumFractionDigits( 0 );

		maxGraph.getGridLabelRenderer().setLabelFormatter( new DefaultLabelFormatter( nf, nf ) );
		maxGraph.getGridLabelRenderer().setTextSize( 10 * PIXEL_DENSITY );
		maxGraph.getGridLabelRenderer().setHorizontalAxisTitleTextSize( 10 * PIXEL_DENSITY );
		maxGraph.getGridLabelRenderer().setVerticalAxisTitleTextSize( 10 * PIXEL_DENSITY );
		avgGraph.getGridLabelRenderer().setLabelFormatter( new DefaultLabelFormatter( nf, nf ) );
		avgGraph.getGridLabelRenderer().setTextSize( 10 * PIXEL_DENSITY );
		avgGraph.getGridLabelRenderer().setHorizontalAxisTitleTextSize( 10 * PIXEL_DENSITY );
		avgGraph.getGridLabelRenderer().setVerticalAxisTitleTextSize( 10 * PIXEL_DENSITY );

		FrameLayout ladderFL2 = new FrameLayout( activity );
		ladderFL2.setLayoutParams( ladderFLParams );
		ladderFL2.addView( liverpoolNomogramService.getAverageGraph() );

		graphLayout.addView( ladderFL );
		graphLayout.addView( ladderFL2 );
		graphLayout.setVisibility( View.INVISIBLE );

		rootView.addView( graphLayout );

		ViewTreeObserver vto = graphLayout.getViewTreeObserver();
		vto.addOnGlobalLayoutListener( new ViewTreeObserver.OnGlobalLayoutListener()
		{
			@Override
			public void onGlobalLayout()
			{
				graphLayout.getViewTreeObserver().removeOnGlobalLayoutListener( this );
				graphReadyListener.onGraphReady( graphLayout, liverpoolNomogramService );
			}
		} );
	}
}
