package com.ensoft.ace.infrastructure.service;

import android.os.Build;
import android.os.Environment;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileService
{
	public String getDefaultSaveDir()
	{
		String dir;
		String folderName = "/ace/";
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R)
		{
			dir = Environment.getExternalStoragePublicDirectory( Environment.DIRECTORY_DOCUMENTS ).getAbsolutePath() + folderName;
		}
		else
		{
			dir = Environment.getExternalStorageDirectory().getAbsolutePath() + folderName;
		}
		return dir;
	}

	public String getStudySaveDir()
	{
		return getDefaultSaveDir() + "estudios/";
	}

	public String getPdfSaveDir()
	{
		return getDefaultSaveDir() + "pdfs/";
	}

	public String getReportSaveDir()
	{
		return  getDefaultSaveDir() + "informes/";
	}

	public List<String> getStudyFiles()
	{
		List<String> files = new ArrayList<>(  );

		File dirFile = new File( getStudySaveDir() );

		if ( !dirFile.exists() )
		{
			dirFile.mkdirs();
		}

		if ( !dirFile.isDirectory() )
		{
			return files;
		}

		for ( File file : dirFile.listFiles() )
		{
			if ( !file.isDirectory() )
			{
				files.add( file.getName() );
			}
		}

 		return files;
	}
}
