package com.ensoft.ace.infrastructure.service;

import lib.printer.thermal.Printer;
import lib.printer.thermal.bluetooth.BluetoothPrinterSocketConnexion;
import lib.printer.thermal.textparser.PrinterTextParser;
import lib.printer.thermal.textparser.PrinterTextParserBarcode;
import lib.printer.thermal.textparser.PrinterTextParserColumn;
import lib.printer.thermal.textparser.PrinterTextParserElement;
import lib.printer.thermal.textparser.PrinterTextParserImg;
import lib.printer.thermal.textparser.PrinterTextParserLine;
import lib.printer.thermal.textparser.PrinterTextParserString;

import org.apache.commons.lang3.StringUtils;

public class EscPosPrinter extends Printer
{

	private BluetoothPrinterSocketConnexion bluetoothPrinter = null;

	public EscPosPrinter( BluetoothPrinterSocketConnexion printer, int printerDpi, float printingWidthMM, int nbrCharactersPerLine ) {
		super(printer, printerDpi, printingWidthMM, nbrCharactersPerLine);
		if (printer != null && (printer.isConnected() || (!printer.isConnected() && printer.connect()))) {
			this.bluetoothPrinter = printer;
		}
	}

	/**
	 * Print a formatted text. Read the README.md for more information about text formatting options.
	 *
	 * @param text Formatted text to be printed.
	 * @return Fluent interface
	 */
	public lib.printer.thermal.Printer printFormattedText( String text ) {
		if (this.bluetoothPrinter == null || this.getNbrCharactersPerLine() == 0) {
			return this;
		}

		PrinterTextParser textParser = new PrinterTextParser(this);
		PrinterTextParserLine[] linesParsed = textParser
				.setFormattedText(text)
				.parse();

		for (PrinterTextParserLine line : linesParsed) {
			PrinterTextParserColumn[] columns = line.getColumns();

			for (PrinterTextParserColumn column : columns) {
				PrinterTextParserElement[] elements = column.getElements();
				for (PrinterTextParserElement element : elements) {
					if(element instanceof PrinterTextParserString) {
						PrinterTextParserString string = (PrinterTextParserString) element;
						if ( !StringUtils.isEmpty( string.getText() ) && !"null".equals( string.getText() ) )
						{
							this.bluetoothPrinter.printText( string.getText(), string.getTextSize(), string.getTextBold(), string.getTextUnderline() );
						}
						else
						{
							this.bluetoothPrinter.newLine();
						}
					} else if(element instanceof PrinterTextParserImg) {
						PrinterTextParserImg img = (PrinterTextParserImg) element;
						this.bluetoothPrinter.printImage(img.getImage());
					} else if(element instanceof PrinterTextParserBarcode) {
						PrinterTextParserBarcode barcode = (PrinterTextParserBarcode) element;
						this.bluetoothPrinter
								.setAlign(barcode.getAlign())
								.printBarcode(barcode.getBarcodeType(), barcode.getCode(), barcode.getHeight());
					}
				}
			}
			this.bluetoothPrinter.newLine();
		}

		this.bluetoothPrinter
				.newLine()
				.newLine()
				.newLine()
				.newLine();

		return this;
	}

	public void addNewLine()
	{
		this.bluetoothPrinter.newLine();
	}
}
