package com.ensoft.ace.infrastructure.service;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.MediaStore;

import com.ensoft.ace.App;

import java.io.File;
import java.util.List;
import java.util.Stack;

import androidx.core.content.FileProvider;

public class EmailService
{
	public Intent createSendChooseIntent( Activity activity, Intent source, CharSequence chooserTitle )
	{
		Stack<Intent> intents = new Stack<>();

		String email = new UserEmailService().getEmail( activity );

		Intent i = new Intent( Intent.ACTION_SENDTO, null != email ? Uri.fromParts( "mailto", email, null ) : Uri.EMPTY );

		List<ResolveInfo> activities = activity.getPackageManager().queryIntentActivities( i, 0 );

		for ( ResolveInfo ri : activities )
		{
			Intent target = new Intent( source );
			target.setPackage( ri.activityInfo.packageName );
			intents.add( target );
		}

		if ( !intents.isEmpty() )
		{
			Intent chooserIntent = Intent.createChooser( intents.remove( 0 ), chooserTitle );

			chooserIntent.putExtra( Intent.EXTRA_INITIAL_INTENTS, intents.toArray( new Parcelable[intents.size()] ) );

			return chooserIntent;
		}
		else
		{
			return Intent.createChooser( source, chooserTitle );
		}
	}

	public void sendFlowmetryFileByMail( Activity activity, String chosenDir )
	{
		Intent i = new Intent( Intent.ACTION_SEND );
		i.setType( "*/*" );
		i.putExtra( Intent.EXTRA_SUBJECT, "Estudio Flujometria" );
		i.putExtra( Intent.EXTRA_TEXT, "Se adjunta archivo del estudio." );
		i.addFlags( Intent.FLAG_GRANT_READ_URI_PERMISSION );
		Uri uri = FileProvider.getUriForFile( App.instance, "com.ensoft.ace",  new File( chosenDir ) );
		i.putExtra( Intent.EXTRA_STREAM, uri );
		activity.startActivity( createSendChooseIntent( activity, i, "Enviar estudio por mail" ) );
	}
}
