package com.ensoft.ace.infrastructure.service;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateService
{
	public Calendar toCalendar( Date date )
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		return cal;
	}

	public Date fromStringFile( String date )
	{
		if ( null != date )
		{
			String[] split = date.split( "/" );

			if ( split.length >= 3 )
			{
				date =  split[2] + "-" + split[1] + "-" + split[0];

				String string = date + " 00:00:00";

				DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

				Date ret = null;

				try
				{
					ret = format.parse(string);
				}
				catch ( ParseException e )
				{
				}

				return ret;
			}
		}

		return null;
	}

	public Date fromString( String date )
	{
		return fromString( date, null );
	}

	public Date fromString( String date, String time )
	{
		if ( null != date && ( null == time || time.isEmpty() ) )
		{
			if ( date.contains( " " ) )
			{
				String[] dateSplit = date.split( " " );

				if ( dateSplit.length >= 2 )
				{
					time = dateSplit[1];
				}
				else
				{
					time = "00:00:00";
				}
			}
			else
			{
				time = "00:00:00";
			}
		}

		String string = date + " " + time;

		DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);

		Date ret = null;

		try
		{
			ret = format.parse(string);
		}
		catch ( ParseException e )
		{
		}

		return ret;
	}

	public String getDateString()
	{
		return getDateString( null );
	}

	public String getDateString( Date fromDate )
	{
		if ( null == fromDate )
		{
			fromDate = Calendar.getInstance().getTime();
		}

		return new SimpleDateFormat( "yyyy-MM-dd" ).format( fromDate );
	}

	public String getDateTimeString()
	{
		return getDateString( null );
	}

	public String getDateTimeString( Date fromDate )
	{
		if ( null == fromDate )
		{
			fromDate = Calendar.getInstance().getTime();
		}

		return new SimpleDateFormat( "yyyy-MM-dd HH:mm:ss" ).format( fromDate );
	}

	public long getCurrentTimestamp()
	{
		return Calendar.getInstance().getTime().getTime() / 1000L;
	}

	public String getDateFormattedString( Date fromDate )
	{
		return new SimpleDateFormat( "MMM dd, yyyy" ).format( fromDate );
	}

	public String getDateFormattedTimestamp( long fromDate )
	{
		return new SimpleDateFormat( "MMM dd, yyyy" ).format( fromTimestamp( fromDate ) );
	}

	public long toTimestamp( Date fromDate )
	{
		return fromDate.getTime() / 1000L;
	}

	public String fromStringToMonthDayNumYear( String date )
	{
		return fromStringToFormat( date, "MMMM d, yyyy" );
	}

	public String fromStringToMonthDayNumYearShort( String date )
	{
		return fromStringToFormat( date, "MMM d, yyyy" );
	}

	public String fromTimestampToFormat( long timestamp, String format )
	{
		return new SimpleDateFormat( format ).format( fromTimestamp( timestamp ) );
	}

	public String fromTimestampToMonthDayNumYear( long timestamp )
	{
		return fromTimestampToFormat( timestamp, "MMMM d yyyy" );
	}

	public String fromTimestampToMonthDayNumYearShort( long timestamp )
	{
		return fromTimestampToFormat( timestamp, "MMM d yyyy" );
	}

	public String toFormat( Date date, String format )
	{
		return new SimpleDateFormat( format ).format( date );
	}

	public String fromStringToFormat( String date, String format )
	{
		return toFormat( fromString( date ), format );
	}

	public Date fromTimestamp( long timestamp )
	{
		return new Date( timestamp * 1000L );
	}

	public String getDateRange( String startDate, String endDate, boolean braces, boolean shortFormat )
	{
		DateService dateService = new DateService();
		String dates = braces ? "(" : "";

		if ( null != endDate && !"0000-00-00 00:00:00".equals( endDate ) )
		{
			Date startDateDate = fromString( startDate );
			Date endDateDate = fromString( endDate );

			Calendar startCalendar = toCalendar( startDateDate );
			Calendar endCalendar = toCalendar( endDateDate );

			if ( startCalendar.get( Calendar.YEAR ) == endCalendar.get( Calendar.YEAR ) )
			{
				String monthFormat = shortFormat ? "MMM" : "MMMM";

				if ( startCalendar.get( Calendar.MONTH ) == endCalendar.get( Calendar.MONTH ) )
				{
					dates += toFormat( startDateDate, monthFormat ) + " " +
						toFormat( startDateDate, "d" ) + "-" +
						toFormat( endDateDate, "d" ) + ", " +
						toFormat( startDateDate, "yyyy" );
				}
				else
				{
					dates += toFormat( startDateDate, monthFormat ) + " " +
						toFormat( startDateDate, "d" ) + " - " +
						toFormat( endDateDate, monthFormat ) + " " +
						toFormat( endDateDate, "d" ) + ", " +
						toFormat( startDateDate, "yyyy" );
				}
			}
			else
			{
				dates += shortFormat ?
					dateService.fromStringToMonthDayNumYearShort( startDate ) :
					dateService.fromStringToMonthDayNumYear( startDate );

				dates += " - " + (
					shortFormat ?
						dateService.fromStringToMonthDayNumYearShort( endDate ) :
						dateService.fromStringToMonthDayNumYear( endDate ) );
			}
		}
		else
		{
			dates += shortFormat ?
				dateService.fromStringToMonthDayNumYearShort( startDate ) :
				dateService.fromStringToMonthDayNumYear( startDate );
		}

		dates += braces ? ")" : "";

		return dates;
	}

	public String getDateRange( String startDate, String endDate )
	{
		return getDateRange( startDate, endDate, true, false );
	}
}
