package com.ensoft.ace.infrastructure.service;


import android.bluetooth.BluetoothDevice;

import lib.printer.thermal.PrinterCommands;

import java.io.IOException;

public class BluetoothPrinterSocketConnexion extends lib.printer.thermal.bluetooth.BluetoothPrinterSocketConnexion
{
	/**
	 * Create new instance of BluetoothPrinterSocketConnexion.
	 *
	 * @param device an instance of android.bluetooth.BluetoothDevice
	 */
	public BluetoothPrinterSocketConnexion( BluetoothDevice device )
	{
		super( device );
	}

	public lib.printer.thermal.bluetooth.BluetoothPrinterSocketConnexion printText( String text, byte[] textSize, byte[] textBold, byte[] textUnderline, int maxlength )
	{
		if ( !this.isOpenedStream() )
		{
			return this;
		}

		try
		{
			byte[] textBytes = text.getBytes( "cp858" );

			if ( maxlength == 0 )
			{
				maxlength = textBytes.length;
			}

			this.outputStream.write( new byte[]{ 0x1B, 0x74, (byte) 0x13 } );
			this.outputStream.write( PrinterCommands.TEXT_SIZE_NORMAL );
			this.outputStream.write( PrinterCommands.TEXT_WEIGHT_NORMAL );
			this.outputStream.write( PrinterCommands.TEXT_UNDERLINE_OFF );

			if ( textSize != null )
			{
				this.outputStream.write( textSize );
			}
			if ( textBold != null )
			{
				this.outputStream.write( textBold );
			}
			if ( textUnderline != null )
			{
				this.outputStream.write( textUnderline );
			}

			this.outputStream.write( textBytes, 0, maxlength );
		}
		catch ( IOException e )
		{
			e.printStackTrace();
		}

		return this;
	}
}
