package com.ensoft.ace.infrastructure.service;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Intent;

import com.ensoft.ace.infrastructure.listener.BluetoothDeviceStatusListener;

import java.util.Set;

import static android.app.Activity.RESULT_OK;

public class BluetoothDeviceFinderService
{
	private final static int REQUEST_ENABLE_BT = 1;
	private BluetoothAdapter bluetoothAdapter = null;
	private BluetoothDevice device = null;
	private BluetoothDeviceStatusListener listener;
	private String bluetoothNameSearch;
	private Activity activity;
	
	public BluetoothDeviceFinderService( Activity activity, BluetoothDeviceStatusListener listener, String bluetoothNameSearch )
	{
		this.activity = activity;
		this.listener = listener;
		this.bluetoothNameSearch = bluetoothNameSearch;
		
		initBT();
	}
	
	private void initBT()
	{
		bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
		
		if ( bluetoothAdapter != null )
		{
			if ( !bluetoothAdapter.isEnabled() )
			{
				Intent enableBtIntent = new Intent( BluetoothAdapter.ACTION_REQUEST_ENABLE );
				
				activity.startActivityForResult( enableBtIntent, REQUEST_ENABLE_BT );
			}
			else
			{
				findBTDevices();
			}
		}
	}
	
	private void findBTDevices()
	{
		boolean found = false;
		Set<BluetoothDevice> pairedDevices = bluetoothAdapter.getBondedDevices();
		
		if ( pairedDevices.size() > 0 )
		{
			for ( BluetoothDevice device : pairedDevices )
			{
				String dn = device.getName();
				
				if ( dn.equals( bluetoothNameSearch ) )
				{
					this.device = device;
					
					try
					{
						found = true;
					}
					catch ( Exception e )
					{
						found = false;
					}
					
					break;
				}
			}
		}
		
		if ( found )
		{
			listener.onDeviceFound( bluetoothAdapter, device );
		}
		else
		{
			listener.onDeviceNotFound();
		}
	}
	
	public void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		if (requestCode == REQUEST_ENABLE_BT)
		{
			if ( resultCode == RESULT_OK )
			{
				findBTDevices();
			}
			else
			{
				listener.onDeviceNotFound();
			}
		}
	}
}
