package com.ensoft.ace.infrastructure.service;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.View;

public class BitmapService
{
	public static Bitmap getBitmapFromView( View view )
	{
		//Define a bitmap with the same size as the view
		Bitmap bitmap = Bitmap.createBitmap( view.getWidth(), view.getHeight(), Bitmap.Config.ARGB_8888 );
		//Bind a canvas to it
		Canvas canvas = new Canvas( bitmap );
		//Get the view's background
		Drawable bgDrawable = view.getBackground();
		if ( bgDrawable != null )
			//has background drawable, then draw it on the canvas
			bgDrawable.draw( canvas );
		else
			//does not have background drawable, then draw white background on the canvas
			canvas.drawColor( Color.WHITE );
		// draw the view on the canvas
		view.draw( canvas );
		//return bitmap
		return bitmap;
	}
}
