package com.ensoft.ace.domain.service.survey;

import java.util.ArrayList;

public class SurveyQuestion<OptionType>
{

	public ArrayList<String> optionsText;
	public ArrayList<OptionType> optionsValues;
	private String questionType;
	private String description;
	private OptionType optionSelected;
	private int groupIndex;
	private boolean isSelected;

	public SurveyQuestion( String questionType, String questionDescription, int groupIndex )
	{
		this.description = questionDescription;
		this.questionType = questionType;
		this.groupIndex = groupIndex;
		optionsText = new ArrayList<>();
		optionsValues = new ArrayList<>();
	}

	public OptionType getOptionSelected()
	{
		return optionSelected;
	}

	public void setOptionSelected( OptionType optionSelected )
	{
		this.optionSelected = optionSelected;
		this.isSelected = true;
	}

	public void setPositionSelected( int positionSelected )
	{
		this.setOptionSelected( optionsValues.get( positionSelected ) );
	}

	public int getOptionSelectedPosition()
	{
		int position;
		if ( isSelected )
		{
			position = optionsValues.indexOf( optionSelected );
		}
		else
		{
			position = -1;
		}

		return position;
	}

	public void addOption( String description, OptionType value )
	{
		optionsText.add( description );
		optionsValues.add( value );
	}

	public String getDescription()
	{
		return description;
	}

	public String getQuestionType()
	{
		return questionType;
	}

	public boolean isSelected()
	{
		return isSelected;
	}

	public int getGroupIndex()
	{
		return groupIndex;
	}

	public void setGroupIndex( int groupIndex )
	{
		this.groupIndex = groupIndex;
	}
}
