package com.ensoft.ace.domain.service.survey;

import java.lang.reflect.Array;
import java.util.ArrayList;

public class Survey<OptionType>
{
	ArrayList<SurveyQuestion<OptionType>> questionList;

	public Survey()
	{
		this.questionList = new ArrayList<>();
	}

	public SurveyQuestion AddQuestion( String questionType, String question, int groupIndex )
	{
		SurveyQuestion surveyQuestion = new SurveyQuestion<OptionType>( questionType, question, groupIndex );
		questionList.add( surveyQuestion );

		return surveyQuestion;
	}

	public SurveyQuestion<OptionType> GetQuestion( int i )
	{
		return questionList.get( i );
	}

	public boolean IsLastQuestion( int i )
	{
		return ( questionList.size() - 1 ) == i;
	}

	public int GetQuestionCount()
	{
		return questionList.size();
	}

	public OptionType[] GetAnswers( Class<OptionType> componentType )
	{
		OptionType[] answers = (OptionType[]) Array.newInstance( componentType, this.GetQuestionCount() );
		int i = 0;
		for ( SurveyQuestion<OptionType> question : questionList )
		{
			if ( question.isSelected() )
			{
				answers[i] = question.getOptionSelected();
			}
			i++;
		}

		return answers;
	}

	public ArrayList<OptionType> GetAnswers( OptionType defaultValue )
	{
		ArrayList<OptionType> answers = new ArrayList<>();
		for ( SurveyQuestion<OptionType> question : questionList )
		{
			if ( question.isSelected() )
			{
				answers.add( question.getOptionSelected() );
			}
			else
			{
				answers.add( defaultValue );
			}
		}
		return answers;
	}

	public void SetAnswers( ArrayList<OptionType> answers, OptionType defaultValue )
	{
		int i = 0;
		for ( SurveyQuestion<OptionType> question : questionList )
		{
			if ( answers.get( i ) != defaultValue )
			{
				question.setOptionSelected( answers.get( i ) );
			}
			i++;
		}
	}

}
