package com.ensoft.ace.domain.service.flowmetry;

import android.util.Log;

import com.ensoft.ace.domain.model.Flowmetry;
import com.ensoft.ace.domain.model.PatientCard;
import com.ensoft.ace.infrastructure.helper.StreamHelper;
import com.ensoft.ace.infrastructure.service.FileService;
import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class FlowmetryStudyFile
{
	private PatientCard patientCard;
	private Flowmetry flowmetry;
	private ArrayList<Integer> answers = new ArrayList<>();
	private String report = "";
	
	public FlowmetryStudyFile()
	{
		for ( int i = 0; i <= 7; i++ )
		{
			answers.add( -1 );
		}
	}
	
	public void load( String chosenDir )
	{
		try
		{
			flowmetry = new Flowmetry();
			patientCard = new PatientCard();
			
			FileInputStream file = new FileInputStream( chosenDir );
			LittleEndianDataInputStream inputStream = new LittleEndianDataInputStream( file );
			
			int version = inputStream.readInt();
			
			if ( 2004 == version )
			{
				patientCard.readFromDataInputStream( version, inputStream );
				
				int nTipo = inputStream.readInt();
				
				flowmetry.setTimeCount( inputStream.readInt() );
				
				if ( patientCard.numEst == 0 ) patientCard.numEst = 1;
				
				if ( patientCard.numEst > 0 )
				{
					for ( int c = 0; c < patientCard.numEst; c++ )
					{
						int val = inputStream.readInt();
						
						for ( int i = 0; i < 12; i++ )
							val = inputStream.readInt();
						
						for ( int i = 0; i < 12; i++ )
							val = inputStream.readInt();
						
						String nombre = StreamHelper.getStringFromStream( inputStream, 30 );
						
						inputStream.skipBytes( 2 ); // mem align
					}
				}

				short[] scale = new short[12];
				for ( int i = 0; i < scale.length; i++ )
					scale[ i ] = inputStream.readShort(); // Escala
				
				answers.clear();
				
				for ( int i = 0; i <= 7; i++ )
				{
					answers.add( (int) inputStream.readShort() );
				}
				
				inputStream.readFloat(); // 0 float
				int nMarca = inputStream.readInt();
				inputStream.readInt(); // nfotos
				inputStream.readInt(); // ncuadros
				inputStream.readInt(); // video
				inputStream.skipBytes( 8 * 26 ); // condiciones
				
				if ( nMarca > 0 )
					inputStream.skipBytes( nMarca * ( 5 + 4 + 4 + 4 + 1 + 200 ) );
				
				flowmetry.readFromDataInputStream( version, inputStream );
				
				int reportFlag = inputStream.readInt();
				
				if ( reportFlag > 0 )
				{
					int reportSize = inputStream.readInt();
					report = inputStream.readUTF();
				}
			}
			else if ( 2005 == version )
			{
				patientCard.readFromDataInputStream( version, inputStream );
				
				answers.clear();
				
				for ( int i = 0; i <= 7; i++ )
				{
					answers.add( (int) inputStream.readShort() );
				}
				
				flowmetry.readFromDataInputStream( version, inputStream );
				
				report = inputStream.readUTF();
			}
		}
		catch ( IOException e )
		{
			Log.d( "Leyendo estudio", null != e.getMessage() ? e.getMessage() : "" );
		}
	}
	
	public boolean save( String chosenDir )
	{
		try
		{
			FileOutputStream fileOutputStream = new FileOutputStream( chosenDir, false );
			LittleEndianDataOutputStream dataOutputStream = new LittleEndianDataOutputStream( fileOutputStream );
			
			int version = 2005;
			
			//Se escribe version
			dataOutputStream.writeInt( version );
			
			//Se escribe la ficha del paciente
			patientCard.writeToDataOutputStream( dataOutputStream );
			
			//Se escribe IPSS, 16 bytes (short int 8)
			if ( answers != null )
			{
				for ( Integer answer : answers )
				{
					dataOutputStream.writeShort( answer );
				}
			}
			else
			{
				for ( int i = 0; i <= 7; i++ )
				{
					dataOutputStream.writeShort( -1 );
				}
			}
			
			//Los datos de la flujometria
			flowmetry.writeToDataOutputStream( dataOutputStream );
			
			//Informe
			dataOutputStream.writeUTF( report );
			
			dataOutputStream.close();
			
			fileOutputStream.close();
			
			return true;
		}
		catch ( IOException e )
		{
			e.printStackTrace();
			return false;
		}
	}
	
	public PatientCard getPatientCard()
	{
		return patientCard;
	}
	
	public void setPatientCard( PatientCard patientCard )
	{
		this.patientCard = patientCard;
	}
	
	public Flowmetry getFlowmetry()
	{
		return flowmetry;
	}
	
	public void setFlowmetry( Flowmetry flowmetry )
	{
		this.flowmetry = flowmetry;
	}
	
	public ArrayList<Integer> getAnswers()
	{
		return answers;
	}
	
	public void setAnswers( ArrayList<Integer> answers )
	{
		this.answers = answers;
	}
	
	public String getReport()
	{
		return report;
	}
	
	public void setReport( String report )
	{
		this.report = report;
	}
	
	public String getFlowmetryFileName()
	{
		return patientCard.getFullName() + " - " + patientCard.getNiceDateString() + ".ace";
	}
	
	public String getFlowmetryFileSavePath()
	{
		return new FileService().getStudySaveDir() + getFlowmetryFileName();
	}
}
