package com.ensoft.ace.domain.service.flowmetry;

import com.ensoft.ace.domain.model.Flowmetry;

public class FlowmetryAnalysis
{
	public static final int TOTALTIME = 6000;
	public int waitSamples = 10;
	public boolean firstSampling = true;
	public float currentVol = 0;
	public float currentFlow = 0;
	private Mode mode = Mode.Automatic;
	private State state = State.Idle;
	private int[] flowHist = new int[TOTALTIME];
	private int[] volumHist = new int[TOTALTIME];
	private short[] flowProm = new short[6];
	private short[] volumProm = new short[6];
	private short flowOffset = 0;
	private short volumOffset = 0;
	private int dataPos = 0;
	private int samplingPos = -1;
	private int latency1SecCount = 0;
	private int latency10SecsCount = 0;
	private int inactiveTicks = 0;
	private int timeInit = 0;        // This is Ti
	private int timeEnd = 0;        // This is Tf
	private int timeCount = 0;
	private boolean lastWasBroken = false;
	private float lastVolume;
	private Event eventListener;

	public FlowmetryAnalysis( Mode mode, int latency, Event eventListener )
	{
		this.mode = mode;
		this.eventListener = eventListener;
		// Number of ticks count needed to complete 1 and 10 seconds.
		latency1SecCount = (int) Math.ceil( 1000.f / (double) latency );
		latency10SecsCount = (int) Math.ceil( 10000.f / (double) latency );
	}

	private void prepareSampling( short volume )
	{
		if ( samplingPos >= 0 )
		{
			//se cargan los arrays de promedios con los primeros 5 datos
			flowProm[samplingPos] = volume;
			volumProm[samplingPos] = volume;
			//y se toma el offset
			flowOffset = volume;
			volumOffset = volume;
		}

		samplingPos++;

		if ( samplingPos == 5 )
		{
			//en el ultimo lugar del array prom pongo el dato actual
			volumProm[5] = volume;

			//variable auxiliar para promediar
			short msb = 0;

			for ( int i = 0; i < 6; i++ )
			{
				msb += volumProm[i];
			}
			
			//promedio los 6 valores del array prom
			msb = (short) ( msb / 6.f );

			//pongo ese promedio en el ultimo lugar del array de flujo
			flowProm[5] = msb;

			//obtengo el flujo
			msb = (short) ( ( flowProm[5] - flowProm[0] ) * 5.f / 2.f );

			//si el flujo es menor a 2 se filtra
			if ( msb <= 2 )
			{
				msb = 0;
			}

			//valor de flujo
			flowHist[dataPos] = msb;
			
			//valor de volumen
			volumHist[dataPos] = volumProm[5] - volumOffset;

			// PLOP!
			if ( volumHist[dataPos] < 0 )
			{
				volumHist[dataPos] = 0; //por si el volumen da negativo
			}

			dataPos++;

			firstSampling = false;
		}
	}

	public boolean push( int volume )
	{
		if ( State.Started == state )
		{
			if ( waitSamples > 0 )
			{
				waitSamples--;
			}
			else if ( firstSampling )
			{
				prepareSampling( (short) volume );
			}
			else
			{
				short realVolume = (short) ( volume - flowOffset );

				//desplazo a la izquierda los valores de los arrays de promedio
				for ( int i = 0; i < 5; i++ )
				{
					flowProm[i] = flowProm[i + 1];
					volumProm[i] = volumProm[i + 1];
				}

				//en el ultimo lugar del array de volumen se pone el dato actual (sin quitar offset)
				volumProm[5] = (short) volume;
				short msb = 0;
				
				for ( int i = 0; i < 6; i++ )
				{
					msb += volumProm[i];
				}
				
				msb = (short) ( msb / 6.f );
				flowProm[5] = msb;
				
				//obtengo el flujo
				msb = (short) ( ( flowProm[5] - flowProm[0] ) * 5.f / 2.f );
				
				//si el flujo es menor a 2 se filtra
				if ( msb <= 2 )
				{
					msb = 0;
				}
				else if ( msb / 50.f >= 80 )
				{
					return false;
				}

				if ( mode == Mode.Automatic && 0 == dataPos && msb < 5 )
				{
					// Starts only when flow is bigger than 5
					return false;
				}
				
				if ( dataPos > 1 && realVolume - volumHist[dataPos-1] > 100 )
				{
					if ( !lastWasBroken )
					{
						lastVolume = realVolume;
						lastWasBroken = true;
						return false;
					}
					else
					{
						lastWasBroken = false;
					}
				}
				else
				{
					lastWasBroken = false;
				}

				// Log.d("Sampleo", "Volumen: " + volumeFloat + " - Offset: " + flowOffset + " = RealVol: " + realVolume + " Flow: " + msb);
				
				flowHist[dataPos] = msb;
				
				if ( realVolume < 0 )
					volumHist[dataPos] = 0;
				else
					volumHist[dataPos] = realVolume;

				//el dato se divide en este momento (para graficar)
				currentVol = volumHist[dataPos] / 4.f;
				currentFlow = flowHist[dataPos] / 5.f;

				findCurve( msb );

				dataPos++;

				if ( dataPos == TOTALTIME )
				{
					end();
				}

				if ( mode == Mode.Automatic )
				{
					if ( msb < 5 )
					{
						inactiveTicks++;

						if ( inactiveTicks >= latency10SecsCount && timeCount > 0 && timeInit > 0 )
						{
							end();
						}
					}
					else
					{
						inactiveTicks = 0;
					}
				}
				
				return true;
			}
		}
		
		return false;
	}

	private void findCurve( short flow )
	{
		if ( 0 == timeInit )
		{
			if ( flow >= 3 )
			{
				timeCount++;

				if ( timeCount >= latency1SecCount )
				{
					timeInit = dataPos - latency1SecCount;
					if ( timeInit < 0 ) timeInit = 0;
					timeCount = 0;
				}
			}
		}
		else
		{
			if ( 0 == timeEnd )
			{
				if ( flow < 4 )
				{
					timeCount++;

					if ( timeCount >= latency10SecsCount * 3 ) // 30 secs
					{
						timeEnd = dataPos;
					}
				}
			}
		}
	}

	public void start()
	{
		state = State.Started;

		if ( null != eventListener )
			eventListener.onFlowmetryStart();
	}

	public void pause()
	{
		state = State.Paused;
	}

	public boolean started()
	{
		return running() || paused();
	}

	public boolean ended()
	{
		return State.Ended == state;
	}

	public boolean paused()
	{
		return State.Paused == state;
	}

	public boolean running()
	{
		return State.Started == state;
	}

	public void end()
	{
		state = State.Ended;
		inactiveTicks = 0;

		if ( 0 == timeEnd )
		{
			timeEnd = dataPos - 1;
		}

		if ( null != eventListener )
			eventListener.onFlowmetryEnd();
	}

	public Flowmetry getFlowmetryData()
	{
		return new Flowmetry( timeInit, timeEnd, flowHist, volumHist );
	}

	public enum Mode
	{
		Manual,
		Automatic
	}

	public enum State
	{
		Idle,
		Started,
		Paused,
		Ended
	}

	public interface Event
	{
		void onFlowmetryStart();

		void onFlowmetryEnd();
	}
}
