package com.ensoft.ace.domain.service.emitter;

import android.app.Activity;
import android.os.Handler;
import android.os.Message;

import com.ensoft.ace.infrastructure.listener.EmitterConnectionResultListener;
import com.ensoft.ace.infrastructure.service.PreferenceService;

public class Emitter
{
	protected Activity activity = null;
	protected Handler handler = null;
	protected Thread workerThread = null;
	protected volatile boolean stopWorker;
	protected PreferenceService preferenceService = new PreferenceService();
	protected EmitterConnectionResultListener emitterConnectionResultListener;

	protected int getCurrentValue()
	{
		return 0;
	}

	public void startWorkerThread()
	{
		stopWorker = false;
		
		workerThread = new Thread( () -> {
			while ( !Thread.currentThread().isInterrupted() && !stopWorker )
			{
				try
				{
					long startT = System.currentTimeMillis();

					int val = getCurrentValue();

					Message msg = new Message();
					msg.arg1 = val;
					handler.sendMessage( msg );

					long diffT = System.currentTimeMillis() - startT;
					long latency = preferenceService.getLatency() - diffT;

					if ( latency > 0 )
					{
						Thread.sleep( latency, 0 );
					}
				}
				catch ( InterruptedException iex )
				{
				}
			}
		} );

		workerThread.start();
	}

	public void setHandlerCallback( Handler.Callback DataReceivedCb )
	{
		handler = new Handler( DataReceivedCb );
	}

	public boolean init( Activity activity, Handler.Callback DataReceivedCb, EmitterConnectionResultListener emitterConnectionResultListener )
	{
		this.activity = activity;
		handler = new Handler( DataReceivedCb );
		this.emitterConnectionResultListener = emitterConnectionResultListener;
		return true;
	}

	public void end()
	{
		stopWorker = true;
	}
}
