package com.ensoft.ace.domain.model;

import com.ensoft.ace.infrastructure.service.DateService;
import com.ensoft.ace.infrastructure.service.FileService;

import java.util.Date;

public class PatientCardFile extends BaseItem
{
	public String path;
	public String fullName;
	public Date date;
	public long epoch;
	public String dateFormated;

	public PatientCardFile( String fullFileName )
	{
		path = new FileService().getStudySaveDir() + fullFileName;

		fullFileName = fullFileName.substring(0, fullFileName.lastIndexOf('.'));

		String[] parts = fullFileName.split( " - " );

		if ( parts.length > 0 )
		{
			String namePart = "";
			String datePart = parts[ parts.length - 1 ].trim();

			for ( int i = 0; i < parts.length - 1; i++ )
			{
				namePart += parts[i];
			}

			fullName = namePart.trim();

			Date rdate = new DateService().fromString( datePart );

			if ( null != rdate )
			{
				dateFormated = datePart;
				date = rdate;
				epoch = date.getTime();
			}
		}
	}

	@Override
	public long getPrimaryKeyValue()
	{
		return ( fullName + epoch ).hashCode();
	}
}
