package com.ensoft.ace.domain.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.ensoft.ace.infrastructure.helper.StreamHelper;
import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PatientCard implements Parcelable
{
	public static final Parcelable.Creator<PatientCard> CREATOR = new Parcelable.Creator<PatientCard>()
	{
		public PatientCard createFromParcel( Parcel in )
		{
			return new PatientCard( in );
		}

		public PatientCard[] newArray( int size )
		{
			return new PatientCard[size];
		}
	};

	private String fullName = "";
	private String emailAddress = "";
	private int age = -1;
	private String city = "";
	private String phoneNumber = "";
	private String medicalInsurance = "";
	private String gender = "";
	private int flowmetryNumber = -1;
	private int dateYear = -1;
	private int dateMonth = -1;
	private int dateDay = -1;
	private String observations = "";
	public int numEst = 0;

	private PatientCard( Parcel in )
	{
		this.fullName = in.readString();
		this.emailAddress = in.readString();
		this.age = in.readInt();
		this.city = in.readString();
		this.phoneNumber = in.readString();
		this.medicalInsurance = in.readString();
		this.gender = in.readString();
		this.flowmetryNumber = in.readInt();
		this.dateYear = in.readInt();
		this.dateMonth = in.readInt();
		this.dateDay = in.readInt();
		this.observations = in.readString();
	}

	public PatientCard()
	{
	}

	public int describeContents()
	{
		return 0;
	}

	public void writeToParcel( Parcel out, int flags )
	{
		out.writeString( this.fullName );
		out.writeString( this.emailAddress );
		out.writeInt( this.age );
		out.writeString( this.city );
		out.writeString( this.phoneNumber );
		out.writeString( this.medicalInsurance );
		out.writeString( this.gender );
		out.writeInt( this.flowmetryNumber );
		out.writeInt( this.dateYear );
		out.writeInt( this.dateMonth );
		out.writeInt( this.dateDay );
		out.writeString( this.observations );
	}

	public String getFullName()
	{
		return fullName;
	}

	public void setFullName( String fullName )
	{
		this.fullName = fullName;
	}

	public String getEmailAddress()
	{
		return emailAddress;
	}

	public void setEmailAddress( String emailAddress )
	{
		this.emailAddress = emailAddress;
	}

	public int getAge()
	{
		return age;
	}

	public void setAge( int age )
	{
		this.age = age;
	}

	public String getCity()
	{
		return city;
	}

	public void setCity( String city )
	{
		this.city = city;
	}

	public String getPhoneNumber()
	{
		return phoneNumber;
	}

	public void setPhoneNumber( String phoneNumber )
	{
		this.phoneNumber = phoneNumber;
	}

	public String getMedicalInsurance()
	{
		return medicalInsurance;
	}

	public void setMedicalInsurance( String medicalInsurance )
	{
		this.medicalInsurance = medicalInsurance;
	}

	public String getGender()
	{
		return gender;
	}

	public void setGender( String gender )
	{
		this.gender = gender;
	}

	public int getFlowmetryNumber()
	{
		return flowmetryNumber;
	}

	public void setFlowmetryNumber( int flowmetryNumber )
	{
		this.flowmetryNumber = flowmetryNumber;
	}

	public void setDate( int year, int month, int day )
	{
		this.dateYear = year;
		this.dateMonth = month;
		this.dateDay = day;
	}

	public boolean isValidDate()
	{
		return this.dateDay != -1 && this.dateMonth != -1 && this.dateYear != -1;
	}

	public String getObservations()
	{
		return observations;
	}

	public void setObservations( String observations )
	{
		this.observations = observations;
	}

	public int getDateYear()
	{
		return dateYear;
	}

	public int getDateMonth()
	{
		return dateMonth;
	}

	public int getDateDay()
	{
		return dateDay;
	}

	public void writeToDataOutputStream( LittleEndianDataOutputStream dataOutputStream ) throws IOException
	{
		dataOutputStream.writeUTF( this.fullName );
		dataOutputStream.writeUTF( this.emailAddress );
		dataOutputStream.writeUTF( this.city );
		dataOutputStream.writeUTF( this.phoneNumber );
		dataOutputStream.writeUTF( this.medicalInsurance );
		dataOutputStream.writeUTF( Integer.toString( this.age ) );
		dataOutputStream.writeBoolean( "Hombre".equals( this.gender ) );
		dataOutputStream.writeUTF( this.getFullDateString() );
		dataOutputStream.writeUTF( this.observations );
		dataOutputStream.writeInt( this.flowmetryNumber );
	}

	public void readFromDataInputStream( int version, LittleEndianDataInputStream dataInputStream ) throws IOException
	{
		if ( 2004 == version )
		{
			this.fullName = StreamHelper.getStringFromStream( dataInputStream, 35 );
			this.emailAddress = StreamHelper.getStringFromStream( dataInputStream, 35 );
			this.city = StreamHelper.getStringFromStream( dataInputStream, 35 );
			this.phoneNumber = StreamHelper.getStringFromStream( dataInputStream, 35 );
			
			dataInputStream.skipBytes( 35 ); // H. Clínica
			
			this.medicalInsurance = StreamHelper.getStringFromStream( dataInputStream, 35 );
			
			String ageStr = StreamHelper.getStringFromStream( dataInputStream, 5 );
			
			if ( !ageStr.isEmpty() )
				this.age = Integer.parseInt( ageStr );

			byte[] sex = new byte[2];
			dataInputStream.read( sex );
			this.gender = sex[0] == 1 ? "Hombre" : "Mujer";
			
			this.observations = StreamHelper.getStringFromStream( dataInputStream, 500 );
			
			dataInputStream.skipBytes( 35 ); // Tipo
			
			String fecha = StreamHelper.getStringFromStream( dataInputStream, 11 );
			dateFromString( fecha );
			dataInputStream.skipBytes( 5 ); // Numero
			dataInputStream.skipBytes( 35 ); // Motivo
			dataInputStream.skipBytes( 35 ); // Requerido
			dataInputStream.skipBytes( 35 ); // Operador
			dataInputStream.skipBytes( 35 ); // DiaClinico
			dataInputStream.skipBytes( 35 ); // DiaUro
			
			dataInputStream.readByte(); // mem align
			
			dataInputStream.readInt(); // NTipo
			
			numEst = dataInputStream.readInt(); // Num Est
		}
		else if ( 2005 == version )
		{
			this.fullName = dataInputStream.readUTF();
			this.emailAddress = dataInputStream.readUTF();
			this.city = dataInputStream.readUTF();
			this.phoneNumber = dataInputStream.readUTF();
			this.medicalInsurance = dataInputStream.readUTF();
			this.age = Integer.parseInt( dataInputStream.readUTF() );
			this.gender = dataInputStream.readBoolean() ? "Hombre" : "Mujer";
			String fecha = dataInputStream.readUTF();
			dateFromString( fecha );
			this.observations = dataInputStream.readUTF();
			this.flowmetryNumber = dataInputStream.readInt();
		}
	}
	
	protected void dateFromString( String date )
	{
		String[] dateParts = date.split( "/" );
		
		if ( dateParts.length >= 3 )
		{
			dateDay = Integer.parseInt( dateParts[0] );
			dateMonth = Integer.parseInt( dateParts[1] );
			dateYear = Integer.parseInt( dateParts[2] );
		}
	}

	public String getNiceDateString()
	{
		if ( isValidDate() )
		{
			return String.format( "%s-%s-%s", this.dateYear, this.dateMonth, this.dateDay );
		}
		return new SimpleDateFormat( "yyyy-MM-dd" ).format( new Date() );
	}

	public String getFullDateString()
	{
		if ( isValidDate() )
		{
			return String.format( "%s/%s/%s", this.dateDay, this.dateMonth, this.dateYear );
		}
		return new SimpleDateFormat( "dd/MM/yyyy" ).format( new Date() );
	}
}
