package com.ensoft.ace.domain.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.ensoft.ace.domain.service.flowmetry.FlowmetryAnalysis;
import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;

import java.io.IOException;

public class Flowmetry implements Parcelable
{
	public static final Parcelable.Creator<Flowmetry> CREATOR
			= new Parcelable.Creator<Flowmetry>()
	{
		public Flowmetry createFromParcel( Parcel in )
		{
			return new Flowmetry( in );
		}

		public Flowmetry[] newArray( int size )
		{
			return new Flowmetry[size];
		}
	};

	private int[] flowHist = new int[FlowmetryAnalysis.TOTALTIME];
	private int[] volumHist = new int[FlowmetryAnalysis.TOTALTIME];
	private int qMaxTime = 0;        // Where's in time the max flow value
	private float qMax = 0;        // Max flow value
	private int netTime = 0;        // The time that the curve received some flow
	private int timeInit = 0;        // This is Ti
	private int timeEnd = 0;        // This is Tf
	private int timeCount = 0;        // This is Tn
	private int totalTime = 0;        //This is TT
	private float qAverage = 0;
	private float qAt2Seconds = 0;
	private float totalVol = 0;
	private float volAtQMaxTime = 0;
	private int timeDescent = 0;
	private int timePaused = 0;       //This is Tp
	private boolean foundResults = false;
	
	public Flowmetry( int timeInit, int timeEnd, int[] flowHist, int[] volumHist )
	{
		this.timeInit = timeInit;
		this.timeEnd = timeEnd;
		this.timeCount = timeEnd - timeInit - 1;
		this.flowHist = flowHist;
		this.volumHist = volumHist;
		findResults();
	}
	
	public Flowmetry()
	{
	}
	
	public Flowmetry( Parcel in )
	{
		this.flowHist = in.createIntArray();
		this.volumHist = in.createIntArray();
		this.qMaxTime = in.readInt();
		this.qMax = in.readFloat();
		this.netTime = in.readInt();
		this.timeInit = in.readInt();
		this.timeEnd = in.readInt();
		this.timeCount = in.readInt();
		findResults();
	}

	public int[] getFlowHist()
	{
		return flowHist;
	}

	public int[] getVolumHist()
	{
		return volumHist;
	}

	public float getQMax()
	{
		return qMax / 5.f;
	}

	public float getQMaxTime()
	{
		return qMaxTime / 10.f ;
	}

	public float getTotalVol()
	{
		return totalVol / 4.f;
	}

	public float getNetTime()
	{
		return netTime / 10.f;
	}
	
	public float getTotalDescTime()
	{
		return timeDescent / 10.f;
	}

	public float getQAt2Seconds()
	{
		return qAt2Seconds / 5.f;
	}

	public float getQAverage()
	{
		return qAverage;
	}

	public float getVolAtQMaxTime()
	{
		return volAtQMaxTime / 4.f;
	}

	public int getTimeInit()
	{
		return timeInit;
	}

	public int getTimeEnd()
	{
		return timeEnd;
	}

	public float getTimePaused()
	{
		return timePaused / 10.f;
	}

	public int describeContents()
	{
		return 0;
	}

	public void writeToParcel( Parcel out, int flags )
	{
		out.writeIntArray( this.flowHist );
		out.writeIntArray( this.volumHist );
		out.writeInt( this.qMaxTime );
		out.writeFloat( this.qMax );
		out.writeInt( this.netTime );
		out.writeInt( this.timeInit );
		out.writeInt( this.timeEnd );
		out.writeInt( this.timeCount );
	}

	public void writeToDataOutputStream( LittleEndianDataOutputStream dataOutputStream ) throws IOException
	{
		int val;
		
		dataOutputStream.writeInt( timeCount );

		for ( int i = 0; i < timeCount; i++ )
		{
			val = flowHist[i];
			dataOutputStream.writeInt( val );
		}

		for ( int i = 0; i < timeCount; i++ )
		{
			val = volumHist[i];
			dataOutputStream.writeInt( val );
		}
	}

	public void readFromDataInputStream( int version, LittleEndianDataInputStream dataInputStream ) throws IOException
	{
		int val;
		
		if ( 2004 == version )
		{
			for ( int i = 0; i < timeCount; i++ )
			{
				val = dataInputStream.readShort();
				flowHist[i] = val;
			}
			
			for ( int i = 0; i < timeCount; i++ )
			{
				val = dataInputStream.readShort();
				volumHist[i] = val;
			}
		}
		else if ( 2005 == version )
		{
			timeCount = dataInputStream.readInt();
			
			for ( int i = 0; i < timeCount; i++ )
			{
				val = dataInputStream.readInt();
				flowHist[i] = val;
			}
			
			for ( int i = 0; i < timeCount; i++ )
			{
				val = dataInputStream.readInt();
				volumHist[i] = val;
			}
		}
		
		findResults();
	}
	
	public float getTotalTime()
	{
		return ( timeEnd - timeInit ) / 10.f;
	}

	public void findResults()
	{
		if ( foundResults )
			return;
		
		for ( int i = volumHist.length - 1; i >= 0; i-- )
		{
			if ( volumHist[i] > 0 )
			{
				timeCount = Math.min( i + 1, volumHist.length - 1 );
				break;
			}
		}
		
		int c = 0;
		for ( int i = 0; i < timeCount; i++ )
		{
			if ( flowHist[i] >= 3 )
			{
				c++;
				if ( c > 10 )
				{
					timeInit = i - 9;
					
					if ( timeInit < 0 ) timeInit = 0;
					
					break;
				}
			}
			else
			{
				c = 0;
			}
		}

		c = 0;

		int aux;
		for ( aux = timeInit; aux < timeCount; aux++ )
		{
			if ( flowHist[aux] < 1 )
			{
				c++;
				if ( c > 300 ) break;
			}
			else
			{
				c = 0;
			}
		}

		//Tiempo Final
		timeEnd = ( aux - c );
		if ( timeEnd < 1 ) timeEnd = 1;

		float maxFlow = 0;
		for ( int i = timeInit; i <= timeEnd; i++ )
		{
			if ( flowHist[i] >= maxFlow )
			{
				maxFlow = flowHist[i];
				//Punto maximo de flujo
				qMaxTime = i - timeInit;
			}
		}
		//Flujo Maximo
		this.qMax = maxFlow;
		
		//Tiempo total
		this.totalTime = timeEnd - timeInit;
		
		//Tiempo Descenso
		this.timeDescent = totalTime - qMaxTime;
		
		//Tiempo Neto
		c = 0;
		for ( int i = timeInit; i < timeEnd; i++ )
		{
			if ( flowHist[i] >= 4 )
			{
				c++;
			}
		}
		this.netTime = c;

		//Q a 2s
		this.qAt2Seconds = flowHist[timeInit + 20];

		//T entre pausas
		timePaused = totalTime - netTime;

		//Volumen total
		if ( timeCount > 0 )
			totalVol = volumHist[timeCount - 1];

		//Vol a QMax
		volAtQMaxTime = volumHist[timeInit+qMaxTime];

		//Q promedio
		float f, f1, f2;
		f = (float) totalTime / 10.f;
		f1 = totalVol / 4.f;
		f2 = qMax / 5.f;

		if ( totalTime > 0 )
		{
			qAverage = f1 / f;
		}
		else
		{
			qAverage = 0;
		}

		if ( f2 <= qAverage ) qAverage = f2 - 0.6f;
		
		foundResults = true;
	}
	
	public void setTimeCount( int timeCount )
	{
		this.timeCount = timeCount;
	}
	
	public boolean foundResults()
	{
		return foundResults;
	}
}
